import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import * as React from 'react';
import useEvent from './useEvent';
import useLayoutEffect from './useLayoutEffect';
import useState from './useState';
/**
 * Similar to `useState` but will use props value if provided.
 * Note that internal use rc-util `useState` hook.
 */

export default function useMergedState(defaultStateValue, option) {
  var _ref = option || {},
      defaultValue = _ref.defaultValue,
      value = _ref.value,
      onChange = _ref.onChange,
      postState = _ref.postState;

  var _useState = useState(function () {
    if (value !== undefined) {
      return value;
    }

    if (defaultValue !== undefined) {
      return typeof defaultValue === 'function' ? defaultValue() : defaultValue;
    }

    return typeof defaultStateValue === 'function' ? defaultStateValue() : defaultStateValue;
  }),
      _useState2 = _slicedToArray(_useState, 2),
      innerValue = _useState2[0],
      setInnerValue = _useState2[1]; // const hasPropValue = value !== undefined;
  // const mergedValue =  value !== undefined ? value : innerValue;
  // const postMergedValue = postState ? postState(mergedValue) : mergedValue;
  // ======================= Sync =======================


  var _useState3 = useState(value !== null && value !== void 0 ? value : innerValue),
      _useState4 = _slicedToArray(_useState3, 2),
      mergedValue = _useState4[0],
      setMergedValue = _useState4[1];

  useLayoutEffect(function () {
    setMergedValue(value !== null && value !== void 0 ? value : innerValue);
  }, [value, innerValue]);
  var postMergedValue = postState ? postState(mergedValue) : mergedValue; // ===================== setState =====================

  var onChangeFn = useEvent(onChange);
  var triggerChange = useEvent(function (updater, ignoreDestroy) {
    setInnerValue(function (prev) {
      var nextValue = typeof updater === 'function' ? updater(prev) : updater;
      return nextValue;
    }, ignoreDestroy);
  }); // ====================== Change ======================
  // const [valueList, setValueList] = useState([mergedValue]);
  // useLayoutEffect(() => {
  //   setValueList(prev => [innerValue, ...prev].slice(0, 2));
  // }, [innerValue]);
  // const onChangeFn = useEvent(onChange);
  // useLayoutEffect(() => {
  //   if (onChangeFn && valueList.length > 1) {
  //     onChangeFn(valueList[0], valueList[1]);
  //   }
  // }, [valueList, onChangeFn]);
  // =================== Uncontrolled ===================
  // Effect of reset value to `undefined`

  var prevValueRef = React.useRef(value);
  React.useEffect(function () {
    if (value === undefined && value !== prevValueRef.current) {
      setInnerValue(value);
    }

    prevValueRef.current = value;
  }, [value]);
  return [postMergedValue, triggerChange];
}